--  
require( "scripts/game/deftasks.lua" );
require( "scripts/game/deftime.lua" );
GameObject = {
    Params = {
        ID="lemonad";
        width=0;
        height=0;
        timerTask=-1;
        TimerFramesCount = 8;
        Personages = {"dad", "mother","sister"};
        glass_count = 1;
        GridData = { 
            1
        };
        RandomTasks=0;
        image="lemonad_brother";
        enabled = 0;        -- do not change this parameter(  )
    };
    ActivePoints = { 
        fill = { 
                   { {}, 1,0,0,  0,  1,0,0 };
                }; 
        drink = { 
                   { {}, 1,0,0,  0,  1,0,0 };
                }; 
    };
    Objects = {};
    --     
    Tasks = {
        fill = { FuncName="MakeTaskExecute",  timer=1, time_tick=20, not_need_action=1, hand_add=1 };
        drink = { FuncName="DrinkTaskExecute", timer=1, time_tick=300, not_need_action=1, hand_add=1 };  
    };
    --     
    Triggers = { 
        timerTrigger = {FuncName="TimerTriger", NotRunWhen={"fill","drink"}, first_timer={2} , timer = {2} ,amount=1, cur_value=0 };
    };
    --      
    InitActiveTasks = {};
    --      
    InitExpectedTasks = {};
};

function GameObject:Get()
    return self;
end

function GetParams()
    aObj = GameObject:Get();   
    return aObj.Params;
end

function OnInit()
    CPP_SetAnimState("no_glass");
end


function MakeTaskExecute()
    local aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    
    if (tTask < 0 ) then 
       tTask = aObject.Tasks.fill.timer; 
    end
    
--[[
    CPP_SetAnimState("time_"..(aObject.Tasks.fill.timer - tTask));
    tTask = tTask - 1;
    
    
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
--]]    
            aObject.Params.timerTask = -1;
            aObject.Params.GlassCount = aObject.Params.glass_count;
            CPP_SetAnimState("two_glass");
            CPP_SetAnimState("value1_"..aObject.Params.GlassCount);            
            if( not PersCash)then PersCash={}; end
            
            for i = 1, table.getn(aObject.Params.Personages) do           
                local pers = aObject.Params.Personages[i];
                if( not PersCash[pers])then
                    PersCash[pers] = CPP_FindObj(pers);
                    if( PersCash[pers] ==0)then PersCash[pers] = nil; end
                end
                
                if( PersCash[pers]~=nil )then
                    CPP_RunStringSubId( PersCash[pers],  "LemonadIsReady()");
                end
            end
            aObject.Params.enabled = 1;
            CPP_PutOnTopExpectedTasks("drink");
            CPP_WantSelect(1);           
            CPP_RecursiveRun("no_lemonad",0);
            
        return 0;
    --end   
    --return 1;
end

function DrinkTaskExecute()
    local aObject = GameObject:Get();
    AddStatParamI("LemonadeUsed",1);
    aObject.Params.GlassCount = aObject.Params.GlassCount - 1;
    if( aObject.Params.GlassCount > 0)then
        CPP_PutOnTopExpectedTasks("drink");
        CPP_WantSelect(1);               
        CPP_SetAnimState("one_glass");        
        CPP_SetAnimState("value1_"..aObject.Params.GlassCount);
    else
        CPP_SetAnimState("no_glass");
        aObject.Params.enabled = 0;
        --CPP_AddExpectedTasks("fill");
        CPP_RecursiveRun("fill_lemonad",0);
    end;
    
    return 0;
end



-- 
function TimerTriger()
    aObject = GameObject:Get();

    --if not CPP_IsObjectExist("") then return end;
    
    local aTrigger = aObject.Triggers.timerTrigger;

    if (aTrigger.under_task == 1) then return; end
    --if (aTrigger.amount <= 0) then return; end
    
    if ((not aTrigger.cur_value) or (aTrigger.cur_value == 0)) then
        aTrigger.cur_value = GetTriggerTimerRand(aTrigger);
        return;
    end
    aTrigger.cur_value = aTrigger.cur_value - 1;
    if (aTrigger.cur_value <= 0) then
        aTrigger.cur_value = 0;
        --      
        aTrigger.under_task = 1;
        --CPP_OtherObjAddExpectedTasks("kreslo","relax",1);
        aObject.Params.enabled = 0;
        --CPP_AddExpectedTasks("fill");
        CPP_RecursiveRun("fill_lemonad",0);
    end
end
